program define table46iv_dynan

* IV regressions. They are sufficiently different from the OLS regressions such that I'm
* going to do it in a different program
  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/table46iv_dynan_`1'_$mydate, replace

  file open myfile using "logfiles/table46iv_dynan_`1'_$mydate.txt", write replace
  set more off
  file open myfilep using "logfiles/table46iv_dynan_`1'_pval$mydate.txt", write replace

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
* drop if _n > 10000

* create the permutation variables:
* 
* 0: IV regression, based on all households who are in the sample
*    for every wave from 2005-2009
* 1: IV regression, based on non-retired households who are in the sample
*    for every wave from 2005-2009
* 2: IV regression, based on non-retired households who are in the sample
*    for every wave from 2005-2009, including dsr on RHS


  local startyr 2007
  local endyr 2009

  quietly gen temp1 = (wgt>=0 & wgt~=.)
  quietly gen temp4 = ((temp1 + l2.temp1 + l4.temp1) == 3)
  quietly replace temp4 = 0 if yr ~= 2009
  by persid:  egen cons_samp = max(temp4)
  drop temp*

  quietly gen temp1 = reth
  quietly replace temp1 = 0 if yr~=`endyr' | temp1==.
  by persid:  egen retsamp = max(temp1)
  drop temp1

  quietly gen temp1 = hboom6
  quietly replace temp1 = 0 if hboom6==. 
  by persid:  egen boomsamp = max(temp1)
  drop temp1

  quietly gen temp1 = homeown
  quietly replace temp1 = 0 if yr~=`startyr' | temp1==.
  by persid:  egen hosamp = max(temp1)
  drop temp1 

  quietly gen mort_fc_yes  = mort_fc_yes_1 == 1 | mort_fc_yes_2 == 1
  quietly gen temp1 = mort_fc_yes
  quietly replace temp1 = 0 if yr~=2009 | temp1==.
  by persid:  egen fcsamp = max(temp1)
  drop temp1 

  quietly gen exit_ho_2 = (homeown==0) & (l2.homeown==1)
  quietly gen temp1 = exit_ho_2
  quietly replace temp1 = 0 if yr~=`endyr' | temp1==.
  by persid:  egen exhosamp = max(temp1)
  drop temp1 

* generate average income

  quietly gen temp1 = 1/3*(myprev + l2.myprev + l4.myprev)
  quietly replace temp1 = 0 if yr~=`endyr' | temp1==.
  by persid:  egen yavg = max(temp1)
  quietly replace temp1 = . if temp1 == 0
  drop temp1

* generate changes

  local vlist d_to_y d_to_a mort_to_hv mort_to_y consxh_to_y networth_to_y nocars mvp_to_y ds_to_y consxh_aa
  local vlist `vlist' consdbt_to_y adds_alts_to_y myprev networth

  foreach ddd in 2 4 {
    foreach vvv in `vlist' {
      quietly gen d`ddd'`vvv' = `vvv' - l`ddd'.`vvv'
    }
  }

* generate ratios of changes to average income

  quietly gen d2consxh_to_yavg = d2consxh_aa / yavg
  quietly gen d2networth_to_yavg = d2networth / yavg
  quietly gen d2myprev_to_yavg = d2myprev / yavg
  
* divide income, consumption, and wealth by 1000

  foreach vvv in myprev consxh_aa networth hsval tot_fin mort_bal veh_bal oth_dbt cons_dbt adds_alts {
     quietly replace `vvv' = `vvv'/1000
  }

* Generate log differences
*
* Actually we are going to use the difference of the inverse hyperbolic sine
* instead because it takes negative values, which otherwise would be a problem
* since we are especially interested in the low-wealth guys.
*
  foreach zzz in 2 4 {
    foreach vvv in consxh_aa myprev hsval tot_fin mort_bal veh_bal_amt oth_dbt networth  {
       quietly gen ihsvar = ln(`vvv' + sqrt(`vvv'^2 + 1))
       quietly gen ld`zzz'`vvv' = 100*(ihsvar - l`zzz'.ihsvar)
       drop ihsvar 
    }
  }

* generate average unemployment rates for t and t-2

  quietly gen avg_ur = 1/2*(state_ur + l2.state_ur)

* permutations

  local depvar ld2consxh_aa
  local othvar hage hcoll myprev state_ur d2state_ur ld2myprev ld2networth
  local dropmore *

  if `1' == 1 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr IV
     local regcomm ivreg
  }   

  if `1' == 2 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local othvar hage hcoll myprev state_ur d2state_ur ld2myprev ld2networth l2.mds_to_y
     local rrr IV
     local extra including DSB on RHS
     local regcomm ivreg
     local dropmore replace dropit = 1 if l2.mds_to_y > 10 & l2.mds_to_y ~=.    
  }   

  quietly gen s1 = insamp 
  quietly gen s2 = (insamp==1) & (hosamp==1)
  quietly gen s3 = (insamp==1) & (hosamp==1) & (boomsamp==0)
  quietly gen s4 = (insamp==1) & (hosamp==1) & (boomsamp==1)

* labels

  label var hage               "Head age"
  label var hcoll              "Head college degree"
  label var myprev             "Income in t-1"
  label var homeown            "Homeowner"
  label var state_ur           "State UR"
  label var d2state_ur         "del(State UR)"
  label var d2networth_to_y    "del(NW/Y)"
  label var d2networth         "del(W)"
  label var d2networth_to_yavg "del(NW/Yavg)"
  label var ld2networth        "del(IHS NW)"
  label var d2consxh_to_y      "del(C/Y)"
  label var d2consxh_aa        "del(C)"
  label var ld2consxh_aa       "del(IHS C)"
  label var d2myprev           "del(Y)"
  label var ld2myprev          "del(IHS Y)"
  label var d2myprev_to_yavg   "del(Y/Yavg)"

* regressions

local note1 Dependent variable is diff of IHS non housing consumption. 
local note2 HHs with complete set of intvws 2005-2009.
local note3 Regressions drop extreme outliers for M/HV & DSR.

foreach ddd in lev dsr {

  capture drop drat* del_drat* lag_drat*

  if "`ddd'" == "lev" {
     quietly gen drat = mort_to_hv
     local dratlab1 "Mort/HV" 
     local dratlab2 "del(Mort/HV)" 
     local instru lag_drat z2state_hpi
     local dropthem replace dropit = 1 if drat > 2 & drat ~=. 
  }
  if "`ddd'" == "dsr" {
     quietly gen drat = mds_to_y
     local dratlab1 "Mort DSR"
     local dratlab2 "del(Mort DSR)"
     local instru lag_drat
     local dropthem replace dropit = 1 if drat > 10 & drat ~=.    
  }

  foreach sss in s1 s2 s3 s4 {
     capture drop lag_drat* 
     capture drop del_drat*
     quietly gen lag_drat = l2.drat
     quietly gen del_drat = drat - l2.drat
     label var drat `drat1lab1'
     label var del_drat `drat1lab2'
     local s_title "`1': `incrowd', `startyr'-`endyr', `rrr', debt var = `dratlab1', `extra'"
     capture drop dropit
     quietly gen dropit = 0
     `dropthem' & `sss'==1 & yr==`endyr' 
     `dropmore' & `sss'==1 & yr==`endyr' 

     quietly eststo:  quietly `regcomm' `depvar' `othvar' ///
           (drat = `instru') ///
           if `sss'==1 & yr==`endyr' & dropit==0

    quietly eststo:  quietly `regcomm' `depvar' `othvar' ///
           (del_drat = `instru') ///
           if `sss'==1 & yr==`endyr' & dropit==0
    }

        esttab using "logfiles/table46iv_dynan_`1'_$mydate.txt", append /// 
        mtitles("Full 1" "Full 2" "H/O 1" "H/O 2" "Nboom 1" "Nboom 2" "Boom 1" "Boom 2") ///
        starlevels(* .15 ** .10 *** .05) ///
        label b(3) se(3) ar2 obslast ///
        title(`s_title') ///
        addnote("`note1' `note2' `note3'") ///
        compress

        esttab using "logfiles/table46iv_dynan_`1'_pval$mydate.txt", append /// 
        mtitles("Full 1" "Full 2" "H/O 1" "H/O 2" "Nboom 1" "Nboom 2" "Boom 1" "Boom 2") ///
        starlevels(* .15 ** .10 *** .05) ///
        label b(3) p(3) ar2 obslast ///
        title(`s'_title') ///
        addnote("`note1' `note2' `note3'") ///
        compress

        eststo clear  
}
capture log close

end
